/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.render;

import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.PlatformHelperClient;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.world.entity.PhotographFrameEntity;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5348;
import net.minecraft.class_5617;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_897;
import net.minecraft.class_9064;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class PhotographFrameEntityRenderer<T extends PhotographFrameEntity>
extends class_897<T> {
    protected final class_776 blockRenderer;

    public PhotographFrameEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.blockRenderer = context.method_43337();
    }

    @NotNull
    public class_2960 getTextureLocation(@NotNull T pEntity) {
        return class_1723.field_21668;
    }

    public class_1091 getModelLocation(T entity, int size) {
        return switch (size) {
            case 0 -> ExposureClient.Models.PHOTOGRAPH_FRAME_SMALL;
            case 1 -> ExposureClient.Models.PHOTOGRAPH_FRAME_MEDIUM;
            case 2 -> ExposureClient.Models.PHOTOGRAPH_FRAME_LARGE;
            default -> throw new IllegalArgumentException("size " + size + " is not valid. Expected 0-2.");
        };
    }

    @NotNull
    protected class_1921 getRenderType() {
        return class_4722.method_24073();
    }

    public void render(@NotNull T entity, float entityYaw, float partialTick, @NotNull class_4587 poseStack, @NotNull class_4597 bufferSource, int packedLight) {
        boolean photographRendered;
        class_3966 entityHitResult;
        class_239 class_2392 = class_310.method_1551().field_1765;
        if (class_2392 instanceof class_3966 && (entityHitResult = (class_3966)class_2392).method_17782() == entity) {
            class_310.method_1551().field_1692 = entity;
        }
        class_2350 direction = entity.method_5735();
        int size = ((PhotographFrameEntity)((Object)entity)).getSize();
        poseStack.method_22903();
        poseStack.method_46416((float)direction.method_10148() * 0.3f, (float)direction.method_10164() * 0.3f, (float)direction.method_10165() * 0.3f);
        super.method_3936(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.method_22909();
        poseStack.method_22903();
        double hangOffset = 0.46875;
        poseStack.method_22904((double)direction.method_10148() * hangOffset, (double)direction.method_10164() * hangOffset, (double)direction.method_10165() * hangOffset);
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(entity.method_36455()));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - entity.method_36454()));
        class_1799 item = ((PhotographFrameEntity)((Object)entity)).getItem();
        if (!item.method_7960() && !(photographRendered = this.renderPhotograph(entity, poseStack, bufferSource, packedLight, item, size))) {
            poseStack.method_22903();
            float scale = 0.65f + (float)((PhotographFrameEntity)((Object)entity)).getSize() * 0.5f;
            poseStack.method_22904(0.0, 0.0, 0.46875);
            poseStack.method_22905(scale, scale, scale * 0.75f);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)((PhotographFrameEntity)((Object)entity)).getItemRotation() * 360.0f / 4.0f));
            Minecrft.get().method_1480().method_23178(item, class_811.field_4319, packedLight, class_4608.field_21444, poseStack, bufferSource, entity.method_37908(), 0);
            poseStack.method_22909();
        }
        if (!((PhotographFrameEntity)((Object)entity)).isFrameInvisible()) {
            this.renderFrame(entity, poseStack, bufferSource, packedLight, size);
        }
        poseStack.method_22909();
    }

    protected void renderFrame(@NotNull T entity, @NotNull class_4587 poseStack, @NotNull class_4597 bufferSource, int packedLight, int size) {
        poseStack.method_22903();
        poseStack.method_46416(-0.5f, -0.5f, -0.5f);
        class_1091 modelLocation = this.getModelLocation(entity, size);
        class_1087 model = PlatformHelperClient.getModel(modelLocation);
        this.blockRenderer.method_3350().method_3367(poseStack.method_23760(), bufferSource.getBuffer(this.getRenderType()), null, model, 1.0f, 1.0f, 1.0f, packedLight, class_4608.field_21444);
        poseStack.method_22909();
    }

    protected boolean renderPhotograph(@NotNull T entity, @NotNull class_4587 poseStack, @NotNull class_4597 bufferSource, int packedLight, class_1799 item, int size) {
        poseStack.method_22903();
        boolean frameInvisible = ((PhotographFrameEntity)((Object)entity)).isFrameInvisible();
        float frameBorderOffset = frameInvisible ? 0.0f : 0.125f;
        float offsetFromCenter = frameInvisible ? 0.497f : 0.48f;
        float desiredSize = (float)(size + 1) - frameBorderOffset * 2.0f;
        poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)((PhotographFrameEntity)((Object)entity)).getItemRotation() * 360.0f / 4.0f));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        poseStack.method_22904(-0.5 * (double)(size + 1) + (double)frameBorderOffset, -0.5 * (double)(size + 1) + (double)frameBorderOffset, (double)offsetFromCenter);
        poseStack.method_22905(desiredSize, desiredSize, 1.0f);
        boolean isGlowing = ((PhotographFrameEntity)((Object)entity)).isGlowing();
        if (isGlowing) {
            packedLight = 0xF000F0;
        }
        int brightness = isGlowing ? 255 : this.getPhotographBrightness(entity);
        boolean photographRendered = ExposureClient.photographRenderer().render(item, false, false, poseStack, bufferSource, packedLight, brightness, brightness, brightness, 255);
        poseStack.method_22909();
        return photographRendered;
    }

    public int getPhotographBrightness(T entity) {
        if (entity.method_5735() == class_2350.field_11036) {
            return 255;
        }
        int lightLevel = entity.method_37908().method_8314(class_1944.field_9282, entity.method_24515());
        float shadeFactor = entity.method_37908().method_24852(entity.method_5735(), true);
        shadeFactor += (1.0f - shadeFactor) * 0.2f;
        int shadedBrightness = (int)(255.0f * shadeFactor);
        int missingLight = 255 - shadedBrightness;
        int lightUp = (int)((float)missingLight * ((float)lightLevel / 15.0f * 0.5f));
        return Math.min(255, shadedBrightness + lightUp);
    }

    protected void renderNameTag(T entity, class_2561 displayName, class_4587 poseStack, class_4597 bufferSource, int packedLight, float partialTick) {
        class_243 vec3;
        double d = this.field_4676.method_23168(entity);
        if (!(d > 4096.0) && (vec3 = entity.method_56072().method_55675(class_9064.field_47745, 0, entity.method_5705(partialTick))) != null) {
            boolean bl = !entity.method_21751();
            poseStack.method_22903();
            double yOffset = entity.method_5735().method_10166().method_10179() ? vec3.field_1351 - 0.2 + (double)((PhotographFrameEntity)((Object)entity)).getSize() * 0.5 : (entity.method_5735().method_10164() > 0 ? vec3.field_1351 - 0.5 : vec3.field_1351 - 1.0);
            poseStack.method_22904(vec3.field_1352, vec3.field_1351 + yOffset, vec3.field_1350);
            poseStack.method_22907(this.field_4676.method_24197());
            poseStack.method_22905(0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = poseStack.method_23760().method_23761();
            float f = class_310.method_1551().field_1690.method_19343(0.25f);
            int j = (int)(f * 255.0f) << 24;
            class_327 font = this.method_3932();
            float g = -font.method_27525((class_5348)displayName) / 2;
            font.method_30882(displayName, g, 0.0f, 0x20FFFFFF, false, matrix4f, bufferSource, bl ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, j, packedLight);
            if (bl) {
                font.method_30882(displayName, g, 0.0f, -1, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, packedLight);
            }
            poseStack.method_22909();
        }
    }

    protected boolean shouldShowName(T entity) {
        if (class_310.method_1498() && !((PhotographFrameEntity)((Object)entity)).getItem().method_7960() && ((PhotographFrameEntity)((Object)entity)).getItem().method_57826(class_9334.field_49631) && class_310.method_1551().field_1692 == entity) {
            double distSqr = class_310.method_1551().field_1692.method_5858(entity);
            float showRangeSqr = entity.method_21751() ? 32.0f : 64.0f;
            return distSqr < (double)(showRangeSqr * showRangeSqr);
        }
        return false;
    }
}

